program Trexdmo2;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdmo2.dpv  $
   
      Rev 1.1   07 Apr 1996 18:30:22   PaulK
   Work in progress on demos
}

uses
  Forms,
  Trexdm02 in 'TREXDM02.PAS' {Form1};

{$R *.RES}
{$R TREXDEMO.RES}

{This demo program scans a Pascal program and reports on the
 number of lines that consist entirely of comments. For example,
 this comment would count as 5 comment lines. But the comment in
 the Uses clause has program text outside the comment on the same
 line and so would not count.}

{The program uses 5 regular expressions to determine
 commenthood. Every line is tested against each one in sequence;
 but a match on one causes the other tests to be skipped. The
 program causes this behaviour by calling SeekEoln after a match.
 T-Rex's normal behaviour is to match every MatchPattern.}

{Here is a walkthrough of the regular expressions you will find
 in the MatchPattern property. There's no room for comments there.}

(* 1: ^ *({[^}]*} * )+$
   Starting at beginning of line "^", there may be 0 or more
   spaces " *" and then a brace "{" [ignore parenthesis for the
   moment; discussed below]. This can be followed by any number
   of nonbrace characters inside the comment "[^}]*" but a
   single closing brace "}" ends the comment. After that, there
   can be zero or more spaces " *". This pattern can be repeated
   more than once (....)+ before the end of line
   "$" is reached. In other words, the comment starts and ends
   on a single line (or several of them all start and end on
   the same line), and there is nothing but spaces before and
   after it/them on that line. [There is a spurious space before
   ")+$" in the expression as shown here to avoid closing this
   Pascal comment prematurely.]                                 *)

(* 2: ^ *{[^}]*$
   Starting at beginning of line "^", there may be 0 or more
   spaces " *" and then a brace "{". This can be followed by
   any number of nonbrace characters inside the comment
   "[^}]*". The end of line "$" is reached before
   a closing brace is found. In other words, the comment starts
   on this line, but does not end on it, and there is nothing but
   spaces before the comment.                                   *)

(* 3: {[^}]*$
   A comment begins "{" on this line, but does not end. There must
   be some non-comment stuff before the left brace, else pattern
   2 would have matched. So this is the start of a multiline
   comment, but does not itself add to the comment linecount,
   because this line does not consist solely of comments.       *)

(* 4: } *$
   A comment ends "}" on this line, and there are only 0 or more
   spaces " *" before the end of line "$" is reached. The comment
   did not begin on this line (else 1-3 would have matched).    *)

(* 5: }
   A comment ends "}" on this line, but 4 did not match so there
   must have been some code after the comment.                  *)

{This is a demo program, not a serious application. The following
 are not handled:
 1. Comments of the form (* *).
 2. Comments that contain left braces.                           }


begin
  Application.CreateForm(TForm1, Form1);
  Application.Run;
end.
